<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ThemeShop
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class PluginShopController extends AppController {

    public function __construct() {
        parent::__construct();
    }

    /**
     * 插件列表 
     */
    public function actionList() {
        $cur_page = Common::queryInt(_g('page'), 1);
        $psize = Common::queryInt(_g('psize'), 20);
        $category_id = Common::queryInt(_g('category_id'));
        $type = Common::queryInt(_g('type'));
        $lprice = _g('lprice');
        $hprice = _g('hprice');
        $keyword = _g('keyword');
        $params = array(
            'page' => $cur_page,
            'psize' => $psize,
            'category_id' => $category_id,
            'type' => $type,
            'lprice' => $lprice,
            'hprice' => $hprice,
            'keyword' => $keyword,
        );

        $data = ZhCurl::getPlugins($params);
        if (!$data) {
            return $this->error('api_network_error', Common::adminURL('admin', 'PluginShop', 'list'));
        }

        $res = json_decode($data, true);

        if ($res["auth"] == "no") {
            return $this->error('api_auth_error', Common::adminURL('admin', 'auth', 'default'));
        }
        $pages = Common::getPages($res['pages']['count'], $cur_page, $psize);
        $auth = json_decode(ZhCurl::getDomainAuth($_SERVER["HTTP_HOST"]), TRUE);
        Core::$tpl->set('cur_auth', $auth);
        Core::$tpl->set('plugins', $res['plugins']);
        Core::$tpl->set('categories', $res['categories']);
        Core::$tpl->set('pages', $pages);
        Core::$tpl->set('search', $params);
        Core::$tpl->set('api_url', ZhCurl::$api_url);
        $res = $this->load('plugins')->getList("1=1");
        foreach ($res['list'] as $key => $value) {
            $myplugin[$value['codeno']] = array("id" => $value['id'], "version" => $value['version'], "url" => $value['url']);
        }
        Core::$tpl->set('myplugin', $myplugin);
    }

    /**
     * 插件下载安装
     * @global type $version
     * @return type 
     */
    public function actionInstall() {
        $pluginsLogic = $this->load('plugins');
        $code = _g('code');
        if ($pluginsLogic->getCount('codeno="' . $code . '"')) {
            return $this->showMessage('plugin_installed');
        }
        $plugin = json_decode(ZhCurl::getPlugin($code), true);
        $target_dir = APP_ROOT . 'upgrade/';
        @mkdir($target_dir);
        $upgrade_dir = $target_dir . $code . '_plugin/';
        $upgrade_zip = $target_dir . $code . '_plugin.zip';
        if (!$plugin) {
            return $this->showMessage('not_permission_download');
        }
        global $version;
        if (strtolower($version['sys_version']) < strtolower($plugin['sys_version'])) {
            return $this->showMessage('sys_version_lower');
        }
        //获取插件前需要考虑授权情况，暂不考虑
        if (!isset($plugin['url']) || !$plugin['url']) {
            return $this->showMessage('not_permission_download');
        }
        $zip_url = $plugin['url'];
        $contents = Common::getRemoteData($zip_url);
        if ($contents) {
            @file_put_contents($upgrade_zip, $contents);
            chmod($upgrade_zip, 0755);
            if (!file_exists($upgrade_zip) || !filesize($upgrade_zip) || filesize($upgrade_zip) == 0) {
                return $this->showMessage('not_find_zip');
            }
            Common::unzip_file($upgrade_zip, $upgrade_dir); //解压
            $cover_file_list = Dir::getAllFiles($upgrade_dir . 'upload/');
            $success = array();
            $failure = array();
            foreach ($cover_file_list as $value) {
                $target_file = str_replace($upgrade_dir . 'upload/', APP_ROOT, $value);
                Common::rmkdir(dirname($target_file));
                if (copy($value, $target_file)) {
                    $success[] = $target_file;
                    echo $target_file . ' ......upgrade Successful!';
                    echo '<br />';
                } else {
                    $failure[] = $target_file;
                    echo $target_file . ' ......<font color=red>upgrade Failure!</font>';
                    echo '<br />';
                }
            }
            //读取插件配置信息
            $config_file = $upgrade_dir . '/config.php';
            require_once $config_file;
            //执行升级的sql
            $sql_num = $plugin_config['sql_index'];
            $cur_sql_num = 0;
            if ($sql_num > $cur_sql_num) {
                $sql_file_array = array();
                for ($i = $cur_sql_num; $i < $sql_num; $i++) {
                    $sql_file_array[] = $upgrade_dir . 'sql/' . $i . '.sql';
                }
                echo '<br />';
                echo '<font color=green>==========开始执行升级sql文件==========</font><br />';
                echo '<br />';
                $this->dealSql($sql_file_array);
            }
            $plugin_data = array(
                'base_name' => $plugin['name'],
                'codeno' => $plugin['code'],
                'version' => $plugin['version'],
                'pre_version' => $plugin['pre_version'],
                'remark' => Common::strEscape($plugin['detail']),
                'dev_author' => "厦门中恒天下",
                'url' => Common::strEscape($plugin_config['plugin_url']),
                'status' => 1,
                'create_time' => SYS_TIME,
            );
            $res = $pluginsLogic->saveByCond($plugin_data);
            Dir::delDirAndFile($upgrade_dir);
            @unlink($upgrade_zip);
            if ($res) {
                return $this->success('operation_success', Common::adminURL('admin', 'plugins', 'list'));
            }
            return $this->showMessage('operation_failure');
        }
    }

    /**
     * 执行sql文件
     * @param array $sql_file_array(sql 文件)
     * @return type 
     */
    function dealSql($sql_file_array) {
        $mysql = mysql_connect(DB_HOST, DB_USER, DB_PSW);
        if ($mysql === FALSE) {
            echo "mysql connect fail, wrong password. Please Manual processing this upgrade's sql";
            return;
        }
        if (mysql_select_db(DB_NAME) === FALSE) {
            echo "select DB fail. Please Manual processing this upgrade's sql";
            return;
        }
        mysql_query("set names utf8");
        $i = 0;
        foreach ($sql_file_array as $sql_file) {
            $fp = fopen($sql_file, "r");
            if ($fp === FALSE) {
                echo 'can not open file (' . $sql_file . ') Please Manual processing this upgrade\'s sql';
                return;
            }
            while ($s = fgets($fp, 100000)) {
                $m .= $s;
            }
            $sql_content = explode(";\n", $m);
            $max = count($sql_content);
            while ($i < $max) {
                mysql_query($sql_content [$i]);

                if (mysql_error()) {
                    echo mysql_error() . " <font color=red>Please Manual processing this upgrade's sql </font><br />";
                } else {
                    $n++;
                }
                $i++;
            }

            fclose($fp);
        }
        echo "<br />mysql queries:" . $n;
    }
    public function actionWpCreateFolder() {
        $code = (_g('code'));
        Core::$tpl->set('code', $code);
    }

    public function actionWpCreateAndUnzip() {
        set_time_limit(0);
        $code = _p('code');
        $folder =  Common::strEscape(_p('foldername'));
        $pluginsLogic = $this->load('plugins');
        if (!$folder) {
            return $this->showMessage('folder name not empty');
        }
        if ($pluginsLogic->getCount('codeno="' . $code . '"')) {
            return $this->showMessage('plugin_installed');
        }
        $plugin = json_decode(ZhCurl::getPlugin($code), true);
        
        $target_dir = APP_ROOT . 'upgrade/';
        @mkdir($target_dir);
        $upgrade_dir = $target_dir . $code . '_plugin/';
        $upgrade_zip = $target_dir . $code . '_plugin.zip';
        if (!$plugin) {
            return $this->showMessage('not_permission_download');
        }
        global $version;
        if (strtolower($version['sys_version']) < strtolower($plugin['sys_version'])) {
            return $this->showMessage('sys_version_lower');
        }
        //获取插件前需要考虑授权情况，暂不考虑
        if (!isset($plugin['url']) || !$plugin['url']) {
            return $this->showMessage('not_permission_download');
        }
        $zip_url = $plugin['url'];
        $contents = Common::getRemoteData($zip_url);
       if ($contents) {
          @file_put_contents($upgrade_zip, $contents);
            chmod($upgrade_zip, 0755);
            if (!file_exists($upgrade_zip) || !filesize($upgrade_zip) || filesize($upgrade_zip) == 0) {
                return $this->showMessage('not_find_zip');
            }
            Common::unzip_file($upgrade_zip, $upgrade_dir); //解压
            $cover_file_list = Dir::getAllFiles($upgrade_dir . 'wordpress/');
            $success = array();
            $failure = array();
            foreach ($cover_file_list as $value) {
                $target_file = str_replace($upgrade_dir, APP_ROOT, $value);
                $target_file = str_replace($upgrade_dir . 'wordpress', APP_ROOT.$folder, $value);
                Common::rmkdir(dirname($target_file));
                if (copy($value, $target_file)) {
                    $success[] = $target_file;
//                    echo $target_file . ' ......upgrade Successful!';
//                    echo '<br />';
                } else {
                    $failure[] = $target_file;
                    echo $target_file . ' ......<font color=red>upgrade Failure!</font>';
                    echo '<br />';
                }
            }
            $plugin_data = array(
                'base_name' => $plugin['name'],
                'codeno' => $plugin['code'],
                'version' => $plugin['version'],
                'pre_version' => $plugin['pre_version'],
                'remark' => Common::strEscape($plugin['detail']),
                'dev_author' => "厦门中恒天下",
                'url' => Common::strEscape($plugin_config['plugin_url']),
                'status' => 1,
                'create_time' => SYS_TIME,
            );
            $res = $pluginsLogic->saveByCond($plugin_data);
            Dir::delDirAndFile($upgrade_dir);
            @unlink($upgrade_zip);
            if ($res) {
                return $this->success('operation_success', Common::adminURL('admin', 'pluginShop', 'wpgetmysqlinfo',$data = array('folder'=>$folder)));
            }
            return $this->showMessage('operation_failure');
        }
    }
    
  public function actionWpGetMysqlInfo() {
        $folder = _g('folder');
        $mysql_info = array(
        'dbhost'=> '数据库主机：'.DB_HOST,
        'db_name'=>'数据库名称：' .DB_NAME,
        'db_user'=>'数据库用户名：'.DB_USER,
        'db_pass'=>'数据库密码：'.DB_PSW,
        );
        $mysql_info_str = implode("\r\n", $mysql_info);
        Core::$tpl->set('folder', $folder);
        Core::$tpl->set('mysql_info_str', $mysql_info_str);
    }

}

?>
